(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    123636,       3730]*)
(*NotebookOutlinePosition[    125263,       3779]*)
(*  CellTagsIndexPosition[    125188,       3773]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Campos conservativos. Teorema de Green", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[{
    \(vector2D[x_: {0, 0}, y_] := Arrow[x, x + y]\ \), "\n", 
    \(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \), "\n", 
    \(\(normaliza[x_]\  := 
        If[Simplify[x . x] == 0, x, \ x/norma[x]];\)\ \n\), "\n", 
    \(\(tgtunit[func_, 
          t_] = \(func'\)[t]\/\@\(\(func'\)[t] . \(func'\)[t]\);\)\), "\n", 
    \(normalunit[func_, t_] := 
      Module[{s}, normaliza[D[tgtunit[func, s], s]] /. s -> t]\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(curvacerradasimple := 
      Module[{graf1, vectgnteunit, vectnormalunit, \[Gamma]}, \[Gamma][t_] = 
          2 {\(-Sin[\[Pi]\ t]\) + 1\/5\ Cos[4\ \[Pi]\ t], 
              Cos[\[Pi]\ t] - 1\/8\ Sin[4  \[Pi]\ t]}; \n
        graf1 = ParametricPlot[\[Gamma][t], {t, 0, 2}, 
            PlotStyle \[Rule] {Thickness[0.01], Hue[0]}, 
            AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
            Epilog -> {{Hue[0. ], 
                  Arrow[\[Gamma][ .15], \[Gamma][ .16], HeadLength ->  .07], 
                  Arrow[\[Gamma][ .55], \[Gamma][ .56], 
                    HeadLength ->  .07], \[IndentingNewLine]Arrow[\[Gamma][ \
.93], \[Gamma][ .94], HeadLength ->  .07], 
                  Arrow[\[Gamma][1.35], \[Gamma][1.36], HeadLength ->  .07], 
                  Arrow[\[Gamma][1.75], \[Gamma][1.76], HeadLength ->  .07]}, 
                Text["\<D\>", 1.5 { .4,  .4}], 
                Text["\<\[Gamma]\>", 2 { .75,  .6}]}, 
            TextStyle -> {FontFamily -> "\<Times\>", FontSize -> 14}, 
            Ticks -> None, PlotRange -> All, AspectRatio -> Automatic, 
            DisplayFunction \[Rule] 
              Identity]; \[IndentingNewLine]vectgnteunit = 
          Graphics[\n\t\tTable[{{Blue, 
                  vector2D[\[Gamma][t], tgtunit[\[Gamma], t]]}, {Red, 
                  PointSize[ .015], Point[\[Gamma][t]]}}, {t, 0. , 2, 
                2/5. }]]; \n
        vectnormalunit = 
          Graphics[\n\t\tTable[
              If[Det[{tgtunit[\[Gamma], t], normalunit[\[Gamma], t]}] > 
                  0, {Green, 
                  vector2D[\[Gamma][t], normalunit[\[Gamma], t]]}, {Green, 
                  vector2D[\[Gamma][t], \(-normalunit[\[Gamma], t]\)]}], {t, 
                0. , 2, 2/5. }]]; \n
        Show[{graf1, vectgnteunit, vectnormalunit}, AspectRatio -> Automatic, 
          DisplayFunction -> $DisplayFunction]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(dominioconagujeros := 
      Module[{graf1, \[Gamma]}, \[IndentingNewLine]\[Gamma][t_] = 
          2 {\(-Sin[\[Pi]\ t]\) + 1\/5\ Cos[4\ \[Pi]\ t], 
              Cos[\[Pi]\ t] - 1\/8\ Sin[4  \[Pi]\ t]}; \n
        graf1 = ParametricPlot[\[Gamma][t], {t, 0, 2}, 
            PlotStyle \[Rule] {Thickness[0.01], Hue[0]}, 
            AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
            Epilog -> {{Hue[0. ], 
                  Arrow[\[Gamma][ .15], \[Gamma][ .16], HeadLength ->  .07], 
                  Arrow[\[Gamma][ .55], \[Gamma][ .56], 
                    HeadLength ->  .07], \[IndentingNewLine]Arrow[\[Gamma][ \
.93], \[Gamma][ .94], HeadLength ->  .07], 
                  Arrow[\[Gamma][1.35], \[Gamma][1.36], HeadLength ->  .07], 
                  Arrow[\[Gamma][1.75], \[Gamma][1.76], HeadLength ->  .07]}, 
                Text["\<D\>", 1.5 { .4,  .4}], 
                Text["\<\[Gamma]\>", 2 { .75,  .6}]}, 
            TextStyle -> {FontFamily -> "\<Times\>", FontSize -> 14}, 
            Ticks -> None, PlotRange -> All, AspectRatio -> Automatic, 
            DisplayFunction \[Rule] Identity]; 
        Show[{graf1, 
            Graphics[{{Hue[0], Thickness[0.01], Circle[{ .5, \(- .5\)},  .3], 
                  Circle[{\(- .5\),  .5},  .3], Hue[ .2], 
                  Disk[{ .5, \(- .5\)},  .28], 
                  Disk[{\(- .5\),  .5},  .28]}, {Hue[0], 
                  Arrow[Reverse[{\(- .5\),  .5} +  .285 {Cos[ .15] +  .01, 
                            Sin[ .15]}], 
                    Reverse[{\(- .5\),  .5} +  .3 {Cos[ .05] -  .035, 
                            Sin[ .05]}], HeadLength\  -> \  .035], 
                  Arrow[Reverse[{ .5, \(- .5\)} +  .285 {Cos[ .15] +  .01, 
                            Sin[ .15]}], 
                    Reverse[{ .5, \(- .5\)} +  .3 {Cos[ .05] -  .025, 
                            Sin[ .05]}], HeadLength\  -> \  .037]}, 
                Text[\*"\"\<\!\(\[Gamma]\_1\)\>\"", { .8, \(- .1\)}], 
                Text[\*"\"\<\!\(\[Gamma]\_2\)\>\"", {\(- .2\),  .9}]}]}, 
          DisplayFunction -> $DisplayFunction]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Campos conservativos", "Section"],

Cell[TextData[{
  "Recuerda que una integral de l\[IAcute]nea de un campo vectorial depende \
de DOS funciones: el campo vectorial  ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y el camino \[Gamma]; necesitas conocer dichas funciones para poder \
calcular la integral. Para ello, todo lo que necesitas es obtener una \
primitiva, G, de la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(g(t)\), "=", 
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold"], "(", \(\[Gamma](t)\), ")"}], 
              "|", \(\[Gamma]\ ' \((t)\)\)}], "\[RightAngleBracket]"}]}], 
        TraditionalForm]]],
  " y aplicar la regla de Barrow "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                  "|", " ", \(\[Gamma]' \((t)\)\)}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_a\%b\), 
              RowBox[{
                StyleBox["g",
                  FontSlant->"Italic"], \((t)\), \(\[DifferentialD]t\)}]}], 
            "=", \(G \((b)\) - G \((a)\)\)}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que la funci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " depende del camino \[Gamma]. Puede ocurrir que dos caminos ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)]],
  " tengan los mismos puntos inicial y final pero las integrales ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox[" ",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TextForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), " ", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TextForm]]],
  " sean distintas. El siguiente importante resultado nos dice que los campos \
vectoriales con la propiedad de que sus integrales de l\[IAcute]nea sobre \
cualquier camino dependen solamente de los puntos inicial y final del camino \
son campos de gradiente, y nos muestra c\[OAcute]mo calcular una integral de \
l\[IAcute]nea de un campo de gradiente."
}], "Text"],

Cell[TextData[{
  StyleBox["Teorema 1",
    FontWeight->"Bold"],
  ". ",
  StyleBox["Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox["A",
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  ", ",
  StyleBox["donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es un conjunto abierto en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  ", ",
  StyleBox["un campo vectorial continuo",
    FontWeight->"Plain"],
  ". Las siguientes afirmaciones son equivalentes.\n",
  StyleBox["a) Para todo camino cerrado \[Gamma] en ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" se verifica que ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{\(\[Integral]\_\[Gamma]\), 
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"]}],
            "TextForm"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox["0",
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[".\nb) La integral de l\[IAcute]nea de ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" es independiente del camino, es decir, cualesquiera sean los \
caminos ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)],
    FontWeight->"Plain"],
  StyleBox[" y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)],
    FontWeight->"Plain"],
  StyleBox[" en ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" con los mismos puntos inicial y final se verifica que ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], "=", 
          RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontWeight->"Bold",
              FontSlant->"Italic"]}]}], TextForm]]],
  StyleBox[".",
    FontWeight->"Plain"],
  "\nc) ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es un campo de gradiente, es decir, existe un campo escalar ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " con derivadas parciales continuas tal que  ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", "x", ")"}], 
            "=", \(\[Del]\(f(x)\)\)}]}], TraditionalForm]]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] A\)]],
  ". \nSi el campo ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " verifica alguna de estas afirmaciones, en cuyo caso las verifica todas, \
se dice que es un ",
  StyleBox["campo conservativo",
    FontWeight->"Bold"],
  " (en ",
  StyleBox["A",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[TextData[{
  StyleBox["Demostraci\[OAcute]n",
    FontWeight->"Bold"],
  ". Es f\[AAcute]cil probar que a) es equivalente a b). No es tan \
f\[AAcute]cil probar que b) implica c) y no lo haremos aqu\[IAcute]. \
Probaremos que c) implica b). Para ello basta tener en cuenta que si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma] : \([a, 
            b]\) \[Rule] \[DoubleStruckCapitalR]\^n\)]],
  " es una curva suave en ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", entonces, por la regla de la cadena, se tiene que la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`G(t) = f(\[Gamma](t))\)]],
  " es derivable y "
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`G\ ' \((t)\) = \(\[LeftAngleBracket]\[Del]\(f(\[Gamma](
                  t))\) | \[Gamma]\ ' \((t)\)\[RightAngleBracket] = \
\[LeftAngleBracket]F(\[Gamma](
                t)) | \[Gamma]\ ' \((t)\)\[RightAngleBracket]\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es decir ",
  Cell[BoxData[
      \(TraditionalForm\`G(t) = f(\[Gamma](t))\)]],
  " es una primitiva de ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]F(\[Gamma](
              t)) | \[Gamma]\ ' \((t)\)\[RightAngleBracket]\)]],
  ", luego"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["\[Del]",
                FontWeight->"Bold"], 
              StyleBox["f",
                FontWeight->"Plain",
                FontSlant->"Italic"]}]}], "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_a\%b\), 
              RowBox[{
                RowBox[{"\[LeftAngleBracket]", 
                  RowBox[{
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                    "|", " ", \(\[Gamma]' \((t)\)\)}], 
                  "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
            RowBox[{
              RowBox[{\(\[Integral]\_a\%b\), 
                RowBox[{
                  RowBox[{"\[LeftAngleBracket]", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"\[Del]", 
                          StyleBox["f",
                            FontSlant->"Italic"]}], \((\[Gamma] \((t)\))\)}], 
                      " ", "|", " ", \(\[Gamma]' \((t)\)\)}], 
                    "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
              
              RowBox[{
                RowBox[{\(\[Integral]\_a\%b\), 
                  RowBox[{
                    RowBox[{
                      StyleBox["G",
                        FontSlant->"Italic"], " ", 
                      "'"}], \((t)\), \(\[DifferentialD]t\)}]}], "=", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["G",
                        FontSlant->"Italic"], \((b)\)}], "-", 
                    RowBox[{
                      StyleBox["G",
                        FontSlant->"Italic"], \((a)\)}]}], "=", 
                  RowBox[{
                    RowBox[{
                      StyleBox["f",
                        FontSlant->"Italic"], \((\[Gamma] \((b)\))\)}], "-", 
                    RowBox[{
                      StyleBox["f",
                        
                        FontSlant->
                          "Italic"], \((\[Gamma] \((a)\))\)}]}]}]}]}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "lo que prueba que la integral de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " a lo largo de \[Gamma] solamente depende de los puntos inicial y final de \
\[Gamma], por tanto ",
  StyleBox["cualesquiera sean los caminos ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)],
    FontWeight->"Plain"],
  StyleBox[" y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)],
    FontWeight->"Plain"],
  StyleBox[" en ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" con los mismos puntos inicial y final se verifica que ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}]}], TextForm]]],
  "."
}], "Text"],

Cell["De la demostraci\[OAcute]n anterior debes recordar la igualdad ", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              RowBox[{
                StyleBox["\[Del]",
                  FontWeight->"Bold"], 
                StyleBox["f",
                  FontWeight->"Plain",
                  FontSlant->"Italic"]}], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], \(\[DifferentialD]\[Gamma]\)}]}], "=", 
          RowBox[{
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], "(", "\[Beta]", ")"}], 
            "-", \(f(\[Alpha])\)}]}]], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
v\[AAcute]lida para cualquier camino \[Gamma] cuyo punto inicial sea \[Alpha] \
y cuyo punto final sea \[Beta].\
\>", "Text"],

Cell[TextData[{
  "En f\[IAcute]sica, cuando un campo vectorial ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es conservativo, a la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " tal que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "=", \(\[Del]f\)}], TraditionalForm]]],
  " se le llama funci\[OAcute]n ",
  StyleBox["potencial",
    FontWeight->"Bold"],
  " de dicho campo y el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\(-f\) \((x)\)\)]],
  " se llama ",
  StyleBox["energ\[IAcute]a potencial",
    FontWeight->"Bold"],
  " del punto ",
  StyleBox["x. ",
    FontSlant->"Italic"],
  "No hay en esto un criterio definido; algunos textos llaman funci\[OAcute]n \
potencial a la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-f\)\)]],
  ". Cuando ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " est\[AAcute] definido en un dominio (ver definici\[OAcute]n m\[AAcute]s \
adelante) la funci\[OAcute]n potencial, cuando existe, es \[UAcute]nica salvo \
una constante aditiva."
}], "Text"],

Cell[TextData[{
  "Conservaci\[OAcute]n de la energ\[IAcute]a en un campo de fuerzas \
conservativo",
  StyleBox[" ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Supongamos un objeto de masa ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " que recorre una trayectoria  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], ":", \([a, b]\)}], 
          "\[Rule]", \(\[DoubleStruckCapitalR]\^3\)}], TraditionalForm]]],
  "de modo que en cada punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " de la trayectoria act\[UAcute]a sobre el m\[OAcute]vil una fuerza total \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", 
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], ")"}], 
        TraditionalForm]]],
  ". En virtud de la segunda ley de Newton del movimiento, se verificar\
\[AAcute] que la fuerza total ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", 
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], ")"}], 
        TraditionalForm]]],
  " que act\[UAcute]a sobre el m\[OAcute]vil en cada punto de la trayectoria \
est\[AAcute] relacionada con la aceleraci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["a",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "'"}], "'"}], \((t)\)}]}], 
        TraditionalForm]]],
  " por la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", 
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "(", "t", ")"}], ")"}], "=", 
          RowBox[{"m", " ", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "'"}], "'"}], \((t)\)}]}], 
        TraditionalForm]]],
  ". En consecuencia, el trabajo realizado por dicha fuerza es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"W", "=", 
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}], "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_a\%b\), 
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((t)\)}], ")"}], 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    "'"}]}], \((t)\), \(\[DifferentialD]t\)}]}], "=", 
            RowBox[{
              RowBox[{\(\[Integral]\_a\%b\), 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox[
                        RowBox[{
                          StyleBox["m",
                            FontSlant->"Italic"], 
                          StyleBox["r",
                            FontWeight->"Bold",
                            FontSlant->"Italic"]}]], "'"}], "'"}], 
                  RowBox[{\((t)\), 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      "'"}]}], \((t)\), \(\[DifferentialD]t\)}]}], "=", 
              RowBox[{
                RowBox[{
                  StyleBox[
                    FractionBox[
                      StyleBox["m",
                        FontSlant->"Italic"], "2"],
                    FontSlant->"Italic"], 
                  RowBox[{\(\[Integral]\_a\%b\), 
                    RowBox[{
                      StyleBox[
                        FractionBox[
                          StyleBox["d",
                            FontSlant->"Italic"], "dt"],
                        FontSlant->"Italic"], 
                      RowBox[{"(", " ", 
                        RowBox[{
                          RowBox[{
                            StyleBox["r",
                              FontWeight->"Bold",
                              FontSlant->"Italic"], "'"}], 
                          RowBox[{\((t)\), 
                            StyleBox[".",
                              FontWeight->"Bold"], 
                            RowBox[{
                              StyleBox["r",
                                FontWeight->"Bold",
                                FontSlant->"Italic"], "'"}]}], \((t)\)}], 
                        ")"}], \(\[DifferentialD]t\)}]}]}], "=", 
                RowBox[{
                  RowBox[{
                    StyleBox[
                      FractionBox[
                        StyleBox["m",
                          FontSlant->"Italic"], "2"],
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontSlant->"Italic"], 
                      RowBox[{
                        StyleBox["||",
                          FontSlant->"Plain"], 
                        RowBox[{
                          RowBox[{
                            StyleBox["r",
                              FontWeight->"Bold",
                              FontSlant->"Italic"], 
                            StyleBox["'",
                              FontSlant->"Plain"]}], 
                          StyleBox[\((b)\),
                            FontSlant->"Plain"]}], 
                        SuperscriptBox[
                          StyleBox["||",
                            FontSlant->"Plain"], "2"], 
                        RowBox[{"-", 
                          RowBox[{
                            StyleBox["||",
                              FontSlant->"Plain"], 
                            RowBox[{
                              RowBox[{
                                StyleBox["r",
                                  FontWeight->"Bold",
                                  FontSlant->"Italic"], 
                                StyleBox["'",
                                  FontSlant->"Plain"]}], 
                              StyleBox[\((a)\),
                                FontSlant->"Plain"]}], 
                            SuperscriptBox[
                              StyleBox["||",
                                FontSlant->"Plain"], "2"]}]}]}], ")"}]}], "=",
                   
                  RowBox[{
                    RowBox[{
                      StyleBox[
                        FractionBox[
                          StyleBox["1",
                            FontSlant->"Plain"], 
                          StyleBox["2",
                            FontSlant->"Plain"]],
                        FontSlant->"Italic"], 
                      StyleBox["m",
                        FontSlant->"Italic"], " ", 
                      StyleBox["v",
                        FontSlant->"Italic"], 
                      SuperscriptBox[
                        StyleBox[\((b)\),
                          FontSlant->"Plain"], "2"]}], "-", 
                    RowBox[{
                      StyleBox[
                        FractionBox[
                          StyleBox["1",
                            FontSlant->"Plain"], 
                          StyleBox["2",
                            FontSlant->"Plain"]],
                        FontSlant->"Italic"], 
                      StyleBox["m",
                        FontSlant->"Italic"], " ", 
                      StyleBox["v",
                        FontSlant->"Italic"], 
                      SuperscriptBox[
                        StyleBox[\((a)\),
                          FontSlant->"Plain"], "2"]}]}]}]}]}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde hemos representado con ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(v(t)\), "=", 
          RowBox[{"||", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], "'"}], \((t)\)}], "||"}]}], 
        TraditionalForm]]],
  " la rapidez del m\[OAcute]vil en el instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  ". La cantidad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FractionBox[
              StyleBox["1",
                FontSlant->"Plain"], 
              StyleBox["2",
                FontSlant->"Plain"]],
            FontSlant->"Italic"], 
          StyleBox["m",
            FontSlant->"Italic"], " ", 
          StyleBox["v",
            FontSlant->"Italic"], 
          SuperscriptBox[
            StyleBox[\((t)\),
              FontSlant->"Plain"], "2"]}], TextForm]]],
  " se llama ",
  StyleBox["energ\[IAcute]a cin\[EAcute]tica",
    FontWeight->"Bold"],
  ". Hemos probado as\[IAcute] que ",
  StyleBox["el trabajo que realiza una fuerza sobre un m\[OAcute]vil es igual \
al incremento que experimeta la energ\[IAcute]a cin\[EAcute]tica del mismo \
debido a la acci\[OAcute]n de dicha fuerza",
    FontSlant->"Italic"],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " Supongamos ahora que un m\[OAcute]vil se mueve dentro de un campo de \
fuerzas conservativo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["c",
                FontWeight->"Bold"]], "(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], "=", \(\[Del]\(f(x, y, z)\)\)}], 
        TraditionalForm]]],
  " donde ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " es un campo escalar. En estas condiciones se define la energ\[IAcute]a \
potencial, ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y, z)\)]],
  ", de un objeto en el punto",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\((x, y, z)\)\)\)]],
  " por la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y, z) = \(-f\) \((x, y, z)\)\)]],
  " y, en consecuencia, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["c",
                FontWeight->"Bold"]], "(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], "=", \(\(-\[Del]P\)\ \((x, y, z)\)\)}], 
        TraditionalForm]]],
  ". En esta situaci\[OAcute]n, por lo visto en el teorema 3, se verifica \
que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(W\_c\), "=", 
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{
              SubscriptBox[
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[\(\(c\)\(\ \)\),
                  FontWeight->"Bold",
                  FontSlant->"Italic"]], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}], "=", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["r",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], 
                RowBox[{
                  RowBox[{
                    StyleBox["\[Del]",
                      FontWeight->"Bold"], 
                    StyleBox["P",
                      FontWeight->"Plain",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontWeight->"Plain",
                    FontSlant->"Italic"], 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  StyleBox[" ",
                    FontWeight->"Bold"], 
                  RowBox[{"\[DifferentialD]", 
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]}]}]}]}], "=", 
            RowBox[{
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((a)\)}], ")"}]}], "-", 
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((b)\)}], 
                  StyleBox[")",
                    FontWeight->"Bold"]}]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Igualdad que expresa que ",
  StyleBox["el trabajo realizado por un campo de fuerzas conservativo al \
mover un objeto a lo largo de un camino es igual a la diferencia de la energ\
\[IAcute]a potencial del objeto en los punto inicial y final del camino",
    FontSlant->"Italic"],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["c)",
    FontWeight->"Bold"],
  " Si adem\[AAcute]s de las fuerzas del campo conservativo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " act\[UAcute]a sobre el m\[OAcute]vil en cada punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " de su trayectoria una fuerza exterior ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(F\_e\),
            FontWeight->"Bold",
            FontSlant->"Italic"], "(", 
          RowBox[{"r", 
            StyleBox["(",
              FontWeight->"Bold"], 
            StyleBox["t",
              FontWeight->"Bold"], 
            StyleBox[")",
              FontWeight->"Bold"]}], 
          StyleBox[")",
            FontWeight->"Bold"]}], TraditionalForm]]],
  ", entonces la fuerza total que act\[UAcute]a sobre el m\[OAcute]vil ser\
\[AAcute] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "=", 
          RowBox[{
            StyleBox[\(F\_c\),
              FontWeight->"Bold"], "+", 
            StyleBox[\(F\_e\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  " y el trabajo realizado por dicha fuerza viene dado por "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"W", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox[
                FractionBox[
                  StyleBox["1",
                    FontSlant->"Plain"], 
                  StyleBox["2",
                    FontSlant->"Plain"]],
                FontSlant->"Italic"], 
              StyleBox["m",
                FontSlant->"Italic"], " ", 
              StyleBox["v",
                FontSlant->"Italic"], 
              SuperscriptBox[
                StyleBox[\((b)\),
                  FontSlant->"Plain"], "2"]}], "-", 
            RowBox[{
              StyleBox[
                FractionBox[
                  StyleBox["1",
                    FontSlant->"Plain"], 
                  StyleBox["2",
                    FontSlant->"Plain"]],
                FontSlant->"Italic"], 
              StyleBox["m",
                FontSlant->"Italic"], " ", 
              StyleBox["v",
                FontSlant->"Italic"], 
              SuperscriptBox[
                StyleBox[\((a)\),
                  FontSlant->"Plain"], "2"]}]}], "=", 
          RowBox[{
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]], 
              RowBox[{
                SubscriptBox[
                  StyleBox["F",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], 
                StyleBox[".",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["\[DifferentialD]",
                    FontSlant->"Plain"], 
                  StyleBox["r",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}]}], "=", 
            RowBox[{
              RowBox[{
                RowBox[{
                  SubscriptBox["\[Integral]", 
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[\(\(c\)\(\ \)\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"]], 
                    StyleBox[".",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["\[DifferentialD]",
                        FontSlant->"Plain"], 
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"]}]}]}], "+", 
                RowBox[{
                  SubscriptBox["\[Integral]", 
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[\(\(e\)\(\ \)\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"]], 
                    StyleBox[".",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["\[DifferentialD]",
                        FontSlant->"Plain"], 
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"]}]}]}]}], "=", 
              RowBox[{
                RowBox[{
                  StyleBox["P",
                    FontSlant->"Italic"], 
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((a)\)}], ")"}]}], "-", 
                RowBox[{
                  StyleBox["P",
                    FontSlant->"Italic"], 
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((b)\)}], ")"}]}], "+", 
                RowBox[{
                  SubscriptBox["\[Integral]", 
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[\(\(e\)\(\ \)\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"]], 
                    StyleBox[".",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["\[DifferentialD]",
                        FontSlant->"Plain"], 
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"]}]}]}]}]}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
de donde se sigue que el trabajo realizado por las fuerzas exteriores al \
campo viene dado por\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"]], 
          RowBox[{
            SubscriptBox[
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[\(\(e\)\(\ \)\),
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            StyleBox[".",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontSlant->"Plain"], 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}], "=", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                StyleBox[
                  FractionBox[
                    StyleBox["1",
                      FontSlant->"Plain"], 
                    StyleBox["2",
                      FontSlant->"Plain"]],
                  FontSlant->"Italic"], 
                StyleBox["m",
                  FontSlant->"Italic"], " ", 
                StyleBox["v",
                  FontSlant->"Italic"], 
                SuperscriptBox[
                  StyleBox[\((b)\),
                    FontSlant->"Plain"], "2"]}], "+", 
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((b)\)}], ")"}]}]}], ")"}], "-", 
          
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                StyleBox[
                  FractionBox[
                    StyleBox["1",
                      FontSlant->"Plain"], 
                    StyleBox["2",
                      FontSlant->"Plain"]],
                  FontSlant->"Italic"], 
                StyleBox["m",
                  FontSlant->"Italic"], " ", 
                StyleBox["v",
                  FontSlant->"Italic"], 
                SuperscriptBox[
                  StyleBox[\((a)\),
                    FontSlant->"Plain"], "2"]}], "+", 
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((a)\)}], ")"}]}]}], ")"}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["d)",
    FontWeight->"Bold"],
  " En particular, si sobre el m\[OAcute]vil no act\[UAcute]an fuerzas \
exteriores, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(F\_e\),
            FontWeight->"Bold"], "=", "0"}], TraditionalForm]]],
  ", y el m\[OAcute]vil se desplaza debido solamente a la acci\[OAcute]n del \
campo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " deducimos que "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox[
              FractionBox[
                StyleBox["1",
                  FontSlant->"Plain"], 
                StyleBox["2",
                  FontSlant->"Plain"]],
              FontSlant->"Italic"], 
            StyleBox["m",
              FontSlant->"Italic"], " ", 
            StyleBox["v",
              FontSlant->"Italic"], 
            SuperscriptBox[
              StyleBox[\((b)\),
                FontSlant->"Plain"], "2"]}], "+", 
          RowBox[{
            StyleBox["P",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \((b)\)}], ")"}]}]}], "=", 
        RowBox[{
          RowBox[{
            StyleBox[
              FractionBox[
                StyleBox["1",
                  FontSlant->"Plain"], 
                StyleBox["2",
                  FontSlant->"Plain"]],
              FontSlant->"Italic"], 
            StyleBox["m",
              FontSlant->"Italic"], " ", 
            StyleBox["v",
              FontSlant->"Italic"], 
            SuperscriptBox[
              StyleBox[\((a)\),
                FontSlant->"Plain"], "2"]}], "+", 
          RowBox[{
            StyleBox["P",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \((a)\)}], ")"}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Igualdad que expresa que la suma de la energ\[IAcute]a cin\[EAcute]tica y \
de la energ\[IAcute]a potencial del objeto permanece constante. Este \
resultado se conoce como ",
  StyleBox["ley de conservaci\[OAcute]n de la energ\[IAcute]a",
    FontWeight->"Bold"],
  " y es v\[AAcute]lida para campos ",
  StyleBox["conservativos",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["El campo gravitacional es conservativo", "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "Vimos en la lecci\[OAcute]n anterior que la fuerza de atracci\[OAcute]n \
gravitacional ejercida por un objeto de masa ",
  StyleBox["M",
    FontSlant->"Italic"],
  " que se encuentra en el origen sobre un objeto de masa unidad (",
  StyleBox["m",
    FontSlant->"Italic"],
  "=1) que se encuentra en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain",
              FontSlant->"Italic"], ")"}]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          RowBox[{
            StyleBox[
              FractionBox[\(\(-\ M\)\ G\ x\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], " ", 
          StyleBox["+",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[
              FractionBox[\(\(-\ M\)\ G\ y\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["j",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox["+",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[
              FractionBox[\(\(-\ M\)\ G\ z\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["k",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center,
  FontWeight->"Bold"],

Cell[TextData[{
  "Este campo vectorial est\[AAcute] definido en el abierto ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^3\\{\((0, 0, 0)\)}\)]],
  ". Es f\[AAcute]cil probar que el campo escalar ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["f",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain",
              FontSlant->"Italic"], ")"}]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        StyleBox[\(\(\(M\)\(\ \)\(G\)\(\ \)\)\/\@\(x\^2 + y\^2 + z\^2\)\),
          FontWeight->"Plain",
          FontSlant->"Italic"]}], TextForm]], "Text",
  TextAlignment->Center,
  FontWeight->"Bold",
  Background->GrayLevel[1]],

Cell[TextData[{
  "es una funci\[OAcute]n potencial para ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", esto es, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
          "=", \(\[Del]\(f(x, y, z)\)\)}], TraditionalForm]]],
  " para todo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\((x, y, z)\) \[Element] A\)\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "An\[AAcute]logamente se prueba que el campo el\[EAcute]ctrico producido \
por una carga ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " es conservativo. La ley de Amp\[EAcute]re nos dice que el campo magn\
\[EAcute]tico producido por una corriente el\[EAcute]ctrica estacionaria no \
es conservativo."
}], "Text"],

Cell["\<\
El siguiente resultado, f\[AAcute]cil de probar, proporciona condiciones \
necesarias para que un campo sea conservativo.\
\>", "Text"],

Cell[TextData[{
  "Teorema 2",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Plain"], "1"], ",", \(F\_2\), ",", "...",
                     ",", \(F\_n\)}], ")"}], ":", "A"}], 
              "\[Rule]", \(\[DoubleStruckCapitalR]\^n\)}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[", donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es un conjunto abierto en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[",",
    FontWeight->"Plain"],
  " ",
  StyleBox["un campo vectorial de clase ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(C\^1\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".  Si ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" es conservativo entonces para todo ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["x",
                      FontWeight->"Plain"], "1"], ",", \(x\_2\), ",", "...", 
                  ",", \(x\_n\)}], ")"}], "\[Element]", "A"}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" y para ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i < j \[LessEqual] n\)],
    FontWeight->"Plain"],
  StyleBox[" se verifica que ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "i"]}], 
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["x",
                  FontSlant->"Italic"], "j"]}]], 
          RowBox[{"(", 
            StyleBox["x",
              FontWeight->"Bold",
              FontSlant->"Italic"], ")"}]}], "=", 
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "j"]}], 
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["x",
                  FontSlant->"Italic"], "i"]}]], 
          RowBox[{"(", 
            StyleBox["x",
              FontWeight->"Bold",
              FontSlant->"Italic"], ")"}], 
          "                        ", \((1)\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para el caso de un campo vectorial de dos variables ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox[\(x, y\),
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox["=",
              FontWeight->"Plain"], 
            StyleBox[\((P(x, y), Q(x, y))\),
              FontWeight->"Plain"]}], 
          StyleBox[" ",
            FontWeight->"Plain"]}], TraditionalForm]]],
  "las condiciones (1) anteriores se reducen a"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              StyleBox["P",
                FontSlant->"Italic"]}], 
            RowBox[{"\[PartialD]", 
              StyleBox["y",
                FontSlant->"Italic"]}]], 
          RowBox[{"(", 
            StyleBox[\(x, y\),
              FontSlant->"Italic"], ")"}]}], "=", 
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              StyleBox["Q",
                FontSlant->"Italic"]}], 
            RowBox[{"\[PartialD]", 
              StyleBox["x",
                FontSlant->"Italic"]}]], 
          RowBox[{"(", 
            StyleBox[\(x, y\),
              FontSlant->"Italic"], ")"}], 
          "                       ", \((2)\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para el caso de un campo vectorial de tres variables ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox[\(x, y, z\),
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox["=",
              FontWeight->"Plain"], 
            StyleBox[\((P(x, y, z), Q(x, y, z), R(x, y, z))\),
              FontWeight->"Plain"]}], 
          StyleBox[" ",
            FontWeight->"Plain"]}], TraditionalForm]]],
  "las condiciones (1) anteriores se reducen a"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["P",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["y",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["Q",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["x",
                  FontSlant->"Italic"]}]], 
            RowBox[{
              StyleBox["(",
                FontSlant->"Italic"], 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}]}], "  ", ",", " ", 
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["P",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["z",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["R",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["x",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}]}], "   ", ",", 
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["Q",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["z",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["R",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["y",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}], "            ", \((3)\)}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es natural preguntarse si las condiciones necesarias del teorema anterior \
son tambi\[EAcute]n suficientes para que un campo sea conservativo. La \
respuesta es que, en general, no son suficientes. Por ejemplo, el campo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], 
            ":", \(\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)}], "\[Rule]", 
          "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
  " dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            StyleBox[\(x, y\),
              FontSlant->"Italic"], ")"}]}], "=", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                StyleBox[\(-y\),
                  FontSlant->"Italic"], 
                StyleBox[\(x\^2 + y\^2\),
                  FontSlant->"Italic"]], ",", 
              FractionBox[
                StyleBox["x",
                  FontSlant->"Italic"], 
                StyleBox[\(x\^2 + y\^2\),
                  FontSlant->"Italic"]]}], ")"}], 
          "                      ", \((4)\)}]}], TextForm]], "Text",
  TextAlignment->Center,
  Background->GrayLevel[1]],

Cell["satisface las igualdades (2) pues", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              StyleBox["P",
                FontSlant->"Italic"]}], 
            RowBox[{"\[PartialD]", 
              StyleBox["y",
                FontSlant->"Italic"]}]], 
          RowBox[{"(", 
            StyleBox[\(x, y\),
              FontSlant->"Italic"], ")"}]}], "=", 
        RowBox[{
          RowBox[{
            FractionBox["\[PartialD]", 
              RowBox[{"\[PartialD]", 
                StyleBox["y",
                  FontSlant->"Italic"]}]], 
            RowBox[{
              StyleBox["(",
                FontSlant->"Italic"], 
              StyleBox[
                FractionBox[
                  StyleBox[\(-y\),
                    FontSlant->"Italic"], 
                  StyleBox[\(x\^2 + y\^2\),
                    FontSlant->"Italic"]],
                FontSlant->"Italic"], ")"}]}], "  ", "=", 
          RowBox[{
            FractionBox[
              RowBox[{
                SuperscriptBox[
                  StyleBox["y",
                    FontSlant->"Italic"], "2"], "-", 
                StyleBox[\(x\^2\),
                  FontSlant->"Italic"]}], 
              SuperscriptBox[
                RowBox[{"(", 
                  StyleBox[\(x\^2 + y\^2\),
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontSlant->"Italic"]}], "2"]], "=", 
            RowBox[{
              RowBox[{
                FractionBox["\[PartialD]", 
                  RowBox[{"\[PartialD]", 
                    StyleBox["x",
                      FontSlant->"Italic"]}]], 
                RowBox[{
                  StyleBox["(",
                    FontSlant->"Italic"], 
                  StyleBox[
                    FractionBox["x", 
                      StyleBox[\(x\^2 + y\^2\),
                        FontSlant->"Italic"]],
                    FontSlant->"Italic"], ")"}]}], "   ", "=", 
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    StyleBox["Q",
                      FontSlant->"Italic"]}], 
                  RowBox[{"\[PartialD]", 
                    StyleBox["x",
                      FontSlant->"Italic"]}]], 
                RowBox[{"(", 
                  StyleBox[\(x, y\),
                    FontSlant->"Italic"], ")"}]}]}]}]}]}], TextForm]], "Text",\

  TextAlignment->Center],

Cell["\<\
Sin embargo la integral de dicho campo en la circunferencia unidad vale\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox[\(C \((\((0, 0)\), 1)\)\),
              FontSlant->"Italic"]], 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], 
        "=", \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\[LeftAngleBracket]\((\(-sen\)\ \
t, cos\ t)\) | \((\(-sen\)\ t, \ 
                    cos\ t)\)\[RightAngleBracket] \[DifferentialD]t = \(\
\[Integral]\_\(-\[Pi]\)\%\[Pi]\[DifferentialD]t = 
            2  \[Pi] \[NotEqual] 0\)\)}], TextForm]], "Text",
  TextAlignment->Center],

Cell["lo que prueba que el campo no es conservativo.", "Text"],

Cell[TextData[{
  StyleBox["Por tanto, las condiciones necesarias (1) no son en general \
suficientes para asegurar que un campo que las cumpla sea conservativo en ",
    FontFamily->"Utopia-Regular"],
  StyleBox["A",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[". Cuando un campo vectorial verifica las condiciones (1) se dice \
que es ",
    FontFamily->"Utopia-Regular"],
  StyleBox["localmente conservativo ",
    FontFamily->"Utopia-Bold",
    FontWeight->"Bold"],
  StyleBox["en el abierto ",
    FontFamily->"Utopia-Regular"],
  StyleBox["A",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[".",
    FontFamily->"Utopia-Regular"]
}], "Text"],

Cell[TextData[{
  "Un conjunto abierto ",
  Cell[BoxData[
      FormBox[
        RowBox[{"A", "\[Subset]", 
          FormBox[\(\[DoubleStruckCapitalR]\^n\),
            "TraditionalForm"]}], TraditionalForm]]],
  " con la propiedad de que dos puntos cualesquiera de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " pueden unirse por medio de una curva contenida en ",
  StyleBox["A",
    FontSlant->"Italic"],
  " se llama un ",
  StyleBox["dominio",
    FontWeight->"Bold"],
  ". Un dominio se llama ",
  StyleBox["simplemente conexo",
    FontWeight->"Bold"],
  " cuando todo camino cerrado en el dominio puede ",
  StyleBox["deformarse de forma continua",
    FontSlant->"Italic"],
  " ",
  StyleBox["sin salirse del dominio",
    FontSlant->"Italic"],
  " hasta convertirlo en un punto ",
  StyleBox["del dominio",
    FontSlant->"Italic"],
  ". La formalizaci\[OAcute]n matem\[AAcute]tica de la idea intuitiva de \
\"deformaci\[OAcute]n continua\" es complicada y considero innecesario \
precisarla aqu\[IAcute]. Intuitivamente, un dominio simplemente conexo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " es un dominio que \"no tiene agujeros\" pero esta idea intuitiva ya no \
sirve para dimensiones mayores que 2. ",
  StyleBox["Si a ",
    FontFamily->"Utopia-Regular"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["le quitamos un punto (o un conjunto finito de puntos) obtenemos \
un dominio que no es simplemente conexo; si esto mismo lo hacemos con ",
    FontFamily->"Utopia-Regular"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["el dominio que obtenemos es simplemente conexo. Un ejemplo de \
dominio simplemente conexo en ",
    FontFamily->"Utopia-Regular"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["es una regi\[OAcute]n acotada del plano cuya frontera es una \
curva cerrada y simple. El siguiente resultado establece condiciones \
suficientes para que un campo localmente conservativo sea conservativo.",
    FontFamily->"Utopia-Regular"]
}], "Text"],

Cell[TextData[{
  "Teorema 3",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Plain"], "1"], ",", \(F\_2\), ",", "...",
                     ",", \(F\_n\)}], ")"}], ":", "A"}], 
              "\[Rule]", \(\[DoubleStruckCapitalR]\^n\)}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[", donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es un conjunto abierto en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[",",
    FontWeight->"Plain"],
  " ",
  StyleBox["un campo vectorial de clase ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(C\^1\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[" que es localmente conservativo en ",
    FontWeight->"Plain"],
  StyleBox["A. ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["Entonces se verifica que ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" es conservativo en todo dominio simplemente conexo contenido en \
",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[".",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell["\<\
Un resultado que es equivalente al anterior y muy \[UAcute]til para calcular \
integrales de l\[IAcute]nea de campos vectoriales es el siguiente.\
\>", "Text"],

Cell[TextData[{
  "Teorema 4",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Plain"], "1"], ",", \(F\_2\), ",", "...",
                     ",", \(F\_n\)}], ")"}], ":", "A"}], 
              "\[Rule]", \(\[DoubleStruckCapitalR]\^n\)}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[", donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es un conjunto abierto en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[",",
    FontWeight->"Plain"],
  " ",
  StyleBox["un campo vectorial de clase ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(C\^1\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["que es localmente conservativo en ",
    FontWeight->"Plain"],
  StyleBox["A.",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["  ",
    FontWeight->"Plain"],
  StyleBox["Sean ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)],
    FontWeight->"Plain"],
  StyleBox[" y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)],
    FontWeight->"Plain"],
  StyleBox[" dos caminos cerrados en ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" (o bien dos caminos con los mismos puntos inicial y final) tales \
que es posible deformar continuamente el camino ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)],
    FontWeight->"Plain"],
  StyleBox[" en el camino ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)],
    FontWeight->"Plain"],
  StyleBox[" sin salirse de ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" (manteniendo fijos los puntos inicial y final), entonces se \
verifica que",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), " ", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], 
        StyleBox["=",
          FontWeight->"Bold"], 
        RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), " ", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Aqu\[IAcute] puedes ver un ejemplo de deformaci\[OAcute]n continua de una \
curva cerrada en la circunferencia unidad.\
\>", "Text"],

Cell[BoxData[{
    \(\(Do[
        ParametricPlot[\((\((Abs[Sin[t] Cos[4  t]] +  .2)\) \((1 - s)\) + 
                s)\) {Cos[t], Sin[t]}, {t, 0, 2  Pi}, 
          AspectRatio \[Rule] Automatic, 
          PlotRange \[Rule] {{\(-1.1\), 1.1}, {\(-1.3\), 1.3}}, 
          PlotStyle \[Rule] {Hue[ .6], Thickness[ .008]}], {s, 0, 
          1,  .1}];\)\), "\[IndentingNewLine]", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[TextData[{
  "Si consideramos el campo definido por (4), el teorema anterior nos dice \
que la circulaci\[OAcute]n de dicho campo es la misma para cualquiera de las \
curvas cerradas que aparecen en la animaci\[OAcute]n anterior, es decir es \
igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(2\)  \(\[Pi]\)\(\ \)\)\)]],
  "en cualquiera de ellas. "
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Estudia si los siguientes campos son conservativos en el dominio que se \
indica en cada caso. Cuando el campo sea conservativo calcula la funci\
\[OAcute]n potencial que se anula en el origen.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\((x - y)\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((y + \(y\^2\) x)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^2\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\((x\^3 + 3 \( y\^2\) x)\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((\(-y\^3\) + 3  y\ x\^2)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^2\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\((2  x\ cos\ y - \ y\ cos\ x)\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((\(-x\^2\) sen\ y - \ sen\ x)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^2\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"2", "x", " ", \(y\^3\), \(z\^4\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"3", \(x\^2\), \(y\^\(\(2\)\(\ \)\)\), \(z\^4\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{"4", \(x\^2\), \(y\^3\), \(z\^3\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^3\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Calcula las siguientes integrales de l\[IAcute]nea:\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["r",
                  FontWeight->"Bold"]], " ", \(y \[DifferentialD]x\)}], " ", 
            "+", " ", \(x \[DifferentialD]y\)}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "(", "t", ")"}], "=", 
            RowBox[{
              RowBox[{\((t + 1)\), \(cos\^4\), " ", "t", " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Bold"], "+", 
              RowBox[{\((t/\[Pi] + \(sen\^4\) t)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \[Pi]\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["r",
                FontWeight->"Bold"]], 
            " ", \(\((z\^3 + 2  x\ y)\) \[DifferentialD]x\)}], " ", "+", 
          " ", \(\(x\^2\) \[DifferentialD]y\), " ", 
          "+", \(3  x\ \(z\^2\) \[DifferentialD]z\)}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "(", "t", ")"}], 
            "=", \([\((1, 1, 2)\), \((1, 1, 1)\), \((0, 1, 1)\), \((1, 2, 
                2)\), \((2, 1, 1)\)]\)}]}], TraditionalForm]]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], 
            RowBox[{\((2  x\ z + sen\ y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}]}], 
          StyleBox[" ",
            FontWeight->"Bold"], "+", 
          RowBox[{"x", " ", "cos", " ", "y", " ", 
            StyleBox["j",
              FontWeight->"Bold"]}], 
          StyleBox[" ",
            FontWeight->"Bold"], "+", 
          RowBox[{\(x\^2\), " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{"cos", " ", "t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Bold"], "+", 
            RowBox[{"sen", " ", "t", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"t", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], 
            RowBox[{"4", \(x\[ExponentialE]\^\(\(\ \)\(z\)\)\), 
              StyleBox["i",
                FontWeight->"Bold"]}]}], " ", "+", 
          RowBox[{"cos", " ", "y", " ", 
            StyleBox["j",
              FontWeight->"Bold"]}], " ", "+", 
          RowBox[{"2", \(x\^2\), \(\[ExponentialE]\^\(\(\ \)\(z\)\)\), " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", " ", 
          RowBox[{
            RowBox[{"t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Bold"], "+", " ", 
            RowBox[{\(t\^2\), " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(t\^4\), " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Indica algunos dominios en los que el campo  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], 
            ":", \(\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)}], 
          "\[Rule]", \(\[DoubleStruckCapitalR]\^2\)}], TraditionalForm]]],
  " dado por"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x, y\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                StyleBox[\(-y\),
                  FontSlant->"Italic"], 
                StyleBox[\(x\^2 + y\^2\),
                  FontSlant->"Italic"]], ",", 
              FractionBox[
                StyleBox["x",
                  FontSlant->"Italic"], 
                StyleBox[\(x\^2 + y\^2\),
                  FontSlant->"Italic"]]}], ")"}]}], "        "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
sea conservativo. Calcula la integral de dicho campo sobre la circunferencia \
de centro (1,1) y radio 1.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Estudia si el campo  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], 
            ":", \(\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)}], 
          "\[Rule]", \(\[DoubleStruckCapitalR]\^2\)}], TraditionalForm]]],
  " dado por"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x, y\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                RowBox[{"2", 
                  StyleBox["x",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["y",
                    FontSlant->"Italic"]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    StyleBox[\(x\^2 + y\^2\),
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontSlant->"Italic"]}], "2"]], ",", 
              FractionBox[
                RowBox[{
                  SuperscriptBox[
                    StyleBox["y",
                      FontSlant->"Italic"], "2"], "-", 
                  SuperscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], "2"]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    StyleBox[\(x\^2 + y\^2\),
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontSlant->"Italic"]}], "2"]]}], ")"}]}], "        "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es conservativo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)]],
  " (ten en cuenta que ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)]],
  " no es un dominio simplemente conexo)."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Teorema de Green", "Section"],

Cell[TextData[{
  "La versi\[OAcute]n m\[AAcute]s elemental del teorema de Green relaciona \
una integral de l\[IAcute]nea sobre una curva cerrada y simple en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " y una integral doble sobre la regi\[OAcute]n acotada por la curva. Se \
dice que una curva \[Gamma] cerrada y simple en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  "est\[AAcute] ",
  StyleBox["orientada positivamente",
    FontWeight->"Bold"],
  " cuando se recorre en sentido contrario a las agujas del reloj. En otras \
palabras, cuando recorremos la curva \[Gamma] en el sentido que indica su \
vector tangente en cada punto, la regi\[OAcute]n interior de \[Gamma] queda \
siempre a nuestra izquierda. \nObserva que estamos usando un resultado, \
conocido como teorema de la curva de Jordan, que afirma que una curva \
\[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " cerrada y simple divide al plano en dos regiones disjuntas cuya frontera \
com\[UAcute]n es la curva. Una de las regiones est\[AAcute] acotada y se \
llama interior de \[Gamma] y la otra se llama exterior de \[Gamma]. Este \
resultado tan intuitivo es muy dif\[IAcute]cil de demostrar. Nos apoyamos en \
\[EAcute]l m\[AAcute]s que nada por comodidad de lenguaje pues para lo que \
estamos haciendo puede evitarse su uso.\nUna definici\[OAcute]n \
matem\[AAcute]tica m\[AAcute]s precisa de lo que se entiende por \"orientaci\
\[OAcute]n positiva\" es la siguiente. Sea \[Gamma] una curva suave cerrada y \
simple; llamemos ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " a la regi\[OAcute]n interior de \[Gamma] y sea ",
  Cell[BoxData[
      \(TraditionalForm\`P \[Element] \[Gamma]\)]],
  " un punto de \[Gamma]. La curva \[Gamma] tiene en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " dos vectores normales unitarios que son opuestos entre s\[IAcute]. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " un vector normal a \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  ". Se dice que ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " es la ",
  StyleBox["normal interior",
    FontWeight->"Bold"],
  " a \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " si hay un n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta] > 0\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`P\  + \ t\ N \[Element] D\)]],
  "  y  ",
  Cell[BoxData[
      \(TraditionalForm\`P\  - \ t\ N \[NotElement] D\)]],
  " siempre que ",
  Cell[BoxData[
      \(TraditionalForm\`0 < t < \[Delta]\)]],
  " (esta condici\[OAcute]n expresa que si se avanza un poquito desde ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " en la direcci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " se entra en ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " y si se avanza en la direcci\[OAcute]n opuesta a ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  "se sale de ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  "). Se dice que \[Gamma] est\[AAcute] orientada positivamente cuando el \
determinante de la matriz cuya primera fila es el vector tangente unitario a \
\[Gamma] en un punto t y cuya segunda fila es el vector normal interior a \
\[Gamma] en un punto t es siempre positivo (de hecho, igual a 1), esto es lo \
mismo que exigir que el giro que lleva el vector tangente unitario al vector \
normal interior sea siempre en sentido contrario a las agujas del reloj. "
}], "Text"],

Cell["\<\
La siguiente gr\[AAcute]fica muestra un ejemplo de una curva cerrada simple \
positivamente orientada. Observa que el giro que lleva el vector tangente (en \
azul) al vector normal interior (en verde) es siempre en sentido contrario a \
las agujas del reloj.\
\>", "Text"],

Cell[BoxData[
    \(\(curvacerradasimple;\)\)], "Input"],

Cell[TextData[{
  "Teorema de Green",
  StyleBox[". ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "Sea \[Gamma] un camino cerrado y simple en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " que est\[AAcute] orientado positivamente y sea ",
  StyleBox["D",
    FontSlant->"Italic"],
  " la regi\[OAcute]n del plano limitada por \[Gamma]. Sean ",
  StyleBox["P",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " campos escalares con derivadas parciales de primer orden continuas \
definidos en un abierto que contiene a ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  ". En estas condiciones se verifica que la integral de l\[IAcute]nea del \
campo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{"P", \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " sobre el camino \[Gamma] es igual a la integral doble de la \
funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["P",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], \((x, y)\)}]}], "  "}], 
        TextForm]]],
  "sobre ",
  StyleBox["D",
    FontSlant->"Italic"],
  ". Es decir"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["\[Gamma]",
                    FontWeight->"Bold"]], 
                RowBox[{
                  RowBox[{
                    StyleBox["P",
                      FontWeight->"Plain",
                      FontSlant->"Italic"], "(", \(x, y\), 
                    ")"}], \(\[DifferentialD]x\)}]}], 
              "+", \(\(Q(x, y)\) \[DifferentialD]y\)}], "=", 
            RowBox[{"\[Integral]", 
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["D",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["Q",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["x",
                              FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["P",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["y",
                              FontSlant->"Italic"]}]], \((x, y)\)}]}], 
                    ")"}], \(\[DifferentialD]\((x, y)\)\)}]}]}]}]}]], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es frecuente representar con \[PartialD]",
  StyleBox["D",
    FontSlant->"Italic"],
  " la curva frontera de ",
  StyleBox["D",
    FontSlant->"Italic"],
  ", es decir \[Gamma], orientada positivamente."
}], "Text"],

Cell["\<\
El teorema de Green permite facilitar el c\[AAcute]lculo de algunas \
integrales de l\[IAcute]nea (o de integrales dobles) transform\[AAcute]ndolas \
en integrales dobles (o en integrales de l\[IAcute]nea). \
\>", "Text"],

Cell[TextData[{
  "Una aplicaci\[OAcute]n del teorema de Green es para calcular \
\[AAcute]reas. Como el \[AAcute]rea de la regi\[OAcute]n ",
  StyleBox["D",
    FontSlant->"Italic"],
  " viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          RowBox[{\(\[Integral]\_D\), 
            RowBox[{
              StyleBox["1",
                FontWeight->"Bold"], \(\[DifferentialD]\((x, y)\)\)}]}]}], 
        TraditionalForm]]],
  " podemos transformar esta integral doble en una integral de l\[IAcute]nea \
sobre la frontera \[PartialD]",
  StyleBox["D ",
    FontSlant->"Italic"],
  "sin m\[AAcute]s que elegir funciones ",
  StyleBox["P",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " tales que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["P",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], \((x, y)\)}]}], " "}], 
        TextForm]]],
  "=1. Hay muchas posibilidades pero las m\[AAcute]s sencillas son ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y) = 0, \ Q(x, y) = x\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y) = \(-y\), \ Q(x, y) = 0\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y) = \(-y\)/2, Q(x, y) = x/2\)]],
  " por lo que obtenemos las siguientes expresiones para el \[AAcute]rea:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(\[CapitalAAcute]rea \((D)\)\),
          FontSlant->"Italic"], "=", 
        RowBox[{
          RowBox[{"\[Integral]", 
            RowBox[{\(\[Integral]\_D\), 
              RowBox[{
                StyleBox["1",
                  FontWeight->"Bold"], \(\[DifferentialD]\((x, y)\)\)}]}]}], 
          "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_\(\[PartialD]\ D\)\), 
              RowBox[{
                StyleBox["x",
                  FontWeight->"Plain",
                  FontSlant->"Italic"], \(\[DifferentialD]y\)}]}], "=", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{\(\[Integral]\_\(\[PartialD]\ D\)\), 
                  RowBox[{
                    StyleBox["y",
                      FontSlant->"Italic"], \(\[DifferentialD]x\)}]}]}], "=", 
              
              RowBox[{
                RowBox[{\(1\/2\), 
                  RowBox[{\(\[Integral]\_\(\[PartialD]\ D\)\), 
                    RowBox[{
                      StyleBox["x",
                        FontSlant->"Italic"], 
                      " ", \(\[DifferentialD]y\)}]}]}], " ", "-", " ", 
                RowBox[{
                  StyleBox["y",
                    FontSlant->"Italic"], 
                  " ", \(\[DifferentialD]x\)}]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Observa que puede demostrarse muy f\[AAcute]cilmente el teorema 4 para el \
caso de dos dimensiones usando el teorema de Green.\
\>", "Text"],

Cell["\<\
El teorema de Green tambi\[EAcute]n es v\[AAcute]lido para regiones acotadas \
por caminos de Jordan en las que se han hecho agujeros, es decir regiones \
acotadas cuya frontera est\[AAcute] formada por varios caminos de Jordan que \
no tienen puntos comunes siempre que cada camino frontera est\[EAcute] \
orientado de modo que la regi\[OAcute]n quede siempre a la izquierda cuando \
se recorre dicho camino. Esto significa que el camino frontera m\[AAcute]s \
exterior de todos (aquel en cuyo interior se encuentra contenida la regi\
\[OAcute]n) debe tener orientaci\[OAcute]n positiva y los restantes caminos \
frontera (los que forman los agujeros - la regi\[OAcute]n se encuentra en el \
exterior de los mismos -) deben tener orientaci\[OAcute]n negativa (recorrido \
en el sentido de las agujas del reloj). En otras palabras, representando por \
\[CapitalGamma] la uni\[OAcute]n de todas las curvas frontera, debe ocurrir \
que el determinante de la matriz cuya primera fila es el vector tangente \
unitario a \[CapitalGamma] en un punto t y cuya segunda fila es el vector \
normal interior a \[CapitalGamma] en un punto t es siempre positivo (de \
hecho, igual a 1).\
\>", "Text"],

Cell[TextData[{
  "Teorema de Green para dominios con agujeros",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox[\(x, y\),
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox["=",
              FontWeight->"Plain"], 
            RowBox[{
              RowBox[{
                StyleBox["P",
                  FontWeight->"Plain"], 
                StyleBox[\((x, y)\),
                  FontWeight->"Plain"], 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox["+",
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox["Q",
                  FontWeight->"Plain"], 
                StyleBox[\((x, y)\),
                  FontWeight->"Plain"], 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], 
          StyleBox[" ",
            FontWeight->"Plain"]}], TraditionalForm]]],
  " ",
  StyleBox["un campo de clase",
    FontWeight->"Plain"],
  " ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(C\^1\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["definido en un abierto ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(A \[Subset] \[DoubleStruckCapitalR]\^2\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[". Sean ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["\[Gamma]",
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[\(\[Gamma]\_1\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["2",
              FontWeight->"Plain"]], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox["...",
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["k",
              FontWeight->"Plain"]]}], TraditionalForm]]],
  StyleBox[" curvas de Jordan en ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" disjuntas dos a dos tales que\n\[FilledSmallCircle] ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[Gamma]\_1\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["2",
              FontWeight->"Plain"]], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox["...",
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["k",
              FontWeight->"Plain"]]}], TraditionalForm]]],
  " ",
  StyleBox["se encuentran en el interior de \[Gamma]",
    FontWeight->"Plain"],
  StyleBox[".\n",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["\[FilledSmallCircle] ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_i\)],
    FontWeight->"Plain"],
  StyleBox[" se encuentra en el exterior de ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_j\)],
    FontWeight->"Plain"],
  " ",
  StyleBox["para ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`i \[NotEqual] j\)],
    FontWeight->"Plain"],
  ".\n\[FilledSmallCircle] ",
  StyleBox["Todas las curvas ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Gamma]", 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox[\(\[Gamma]\_1\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["\[Gamma]",
                FontWeight->"Plain"], 
              StyleBox["2",
                FontWeight->"Plain"]],
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox["...",
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["\[Gamma]",
                FontWeight->"Plain"], 
              StyleBox["k",
                FontWeight->"Plain"]],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["est\[AAcute]n orientadas positivamente (sentido antihorario).\n\
Sea ",
    FontWeight->"Plain"],
  StyleBox["D",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" la regi\[OAcute]n obtenida por la intersecci\[OAcute]n del \
interior de \[Gamma] con el exterior de cada una de las curvas ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[Gamma]\_1\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["2",
              FontWeight->"Plain"]], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox["...",
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["k",
              FontWeight->"Plain"]]}], TraditionalForm]]],
  StyleBox[". En estas hip\[OAcute]tesis se verifica que",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[\(\[DifferentialD]\[Gamma]\),
                FontWeight->"Bold",
                FontSlant->"Plain"]}]}], "-", 
          RowBox[{\(\[Sum]\+\(j = 1\)\%k\), 
            RowBox[{
              SubscriptBox["\[Integral]", 
                SubscriptBox[
                  StyleBox["\[Gamma]",
                    FontWeight->"Bold"], "j"]], 
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[".",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["\[DifferentialD]",
                    FontWeight->"Bold",
                    FontSlant->"Plain"], 
                  SubscriptBox[
                    StyleBox["\[Gamma]",
                      FontWeight->"Bold",
                      FontSlant->"Plain"], "j"]}]}]}]}]}], "=", 
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["D",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["Q",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["x",
                          FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["P",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["y",
                          FontSlant->"Italic"]}]], \((x, y)\)}]}], 
                ")"}], \(\[DifferentialD]\((x, y)\)\)}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Observa que en el enunciado del teorema hemos supuesto que todas las curvas \
tienen orientaci\[OAcute]n antihoraria y por eso, en la igualdad anterior, \
las integrales sobre las curvas interiores se restan en lugar de sumarse.\
\>", "Text"],

Cell[TextData[{
  "En particular, si el campo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox[\(x, y\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{
              StyleBox["P",
                FontWeight->"Plain"], 
              StyleBox[\((x, y)\),
                FontWeight->"Plain"], 
              StyleBox["i",
                FontWeight->"Bold"]}], 
            StyleBox["+",
              FontWeight->"Plain"], 
            RowBox[{
              RowBox[{
                StyleBox["Q",
                  FontWeight->"Plain"], "(", 
                StyleBox[\(x, y\),
                  FontWeight->"Plain"], 
                StyleBox[")",
                  FontWeight->"Plain"]}], 
              StyleBox["j",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Plain"]}]}]}], TraditionalForm]]],
  "es conservativo en un abierto que contiene a ",
  StyleBox["D",
    FontSlant->"Italic"],
  ", se verifica que ",
  StyleBox[" ",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[".",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[\(\[DifferentialD]\[Gamma]\),
              FontWeight->"Bold",
              FontSlant->"Plain"]}]}], 
        StyleBox["=",
          FontWeight->"Bold",
          FontSlant->"Plain"], 
        RowBox[{\(\[Sum]\+\(j = 1\)\%k\), 
          RowBox[{
            SubscriptBox["\[Integral]", 
              SubscriptBox[
                StyleBox["\[Gamma]",
                  FontWeight->"Bold"], "j"]], 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], 
                SubscriptBox[
                  StyleBox["\[Gamma]",
                    FontWeight->"Bold",
                    FontSlant->"Plain"], "j"]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Este resultado permite reducir el c\[AAcute]lculo de una integral de l\
\[IAcute]nea de un campo conservativo sobre una curva \[Gamma] que puede ser \
complicada, al c\[AAcute]lculo de una o varias integrales sobre curvas \
sencillas (por ejemplo, circunferencias).\
\>", "Text"],

Cell["\<\
La siguiente gr\[AAcute]fica muestra un ejemplo de un dominio como el que se \
considera en el enunciado del teorema.\
\>", "Text"],

Cell[BoxData[
    \(\(dominioconagujeros;\)\)], "Input"],

Cell["\<\
Naturalmente, la raz\[OAcute]n de considerar dominios con agujeros es porque \
se supone que en esos agujeros el campo tiene alg\[UAcute]n tipo de \
singularidad. Con frecuencia un agujero est\[AAcute] producido por un punto \
en el que el campo se hace infinito.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Comprueba la validez del teorema de Green en cada uno de los siguientes \
casos.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
            RowBox[{
              RowBox[{"x", " ", \(y\^2\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Bold"], "-", " ", 
              RowBox[{"y", " ", \(x\^2\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
            RowBox[{
              RowBox[{"x", " ", "y", " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Bold"], "+", " ", 
              RowBox[{\(y\^3\), " ", \(x\^2\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] = \([\((0, 0)\), \((1, 0)\), \((1, 2)\), \((0, 0)\)]\)\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\((x\^2 + \ y\^2)\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Bold"], "+", " ", 
            RowBox[{"2", "x", " ", "y", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", \[Gamma] es el camino obtenido por la yuxtaposici\[OAcute]n del segmento \
de par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  " de (0,0) a (2,4) y de la poligonal ",
  Cell[BoxData[
      \(TraditionalForm\`\([\((2, 4)\), \((0, 4)\), \((0, 0)\)]\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Utiliza el teorema de Green para calcular el \[AAcute]rea de las regiones \
del plano limitadas por las siguientes curvas.\na) La elipse, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((a\ cos\ t, b\ sen\ t)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0, \ b > 0\)]],
  ".\nb) La astroide, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma](t) = \((a\ \(cos\^3\) t, \ a\ \(sen\^3\) t)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0\)]],
  ".\nc) Un arco de cicloide, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", " ", 
          RowBox[{
            RowBox[{\(a(t - sen\ t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(a(1 - cos\ t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0. \)]],
  "\nd) Una poligonal cerrada orientada positivamente ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma] = \([\((x\_1, y\_1)\), \)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\((x\_2, y\_2)\)\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_3, y\_3)\)\)]],
  ",...,",
  Cell[BoxData[
      \(TraditionalForm\`\(\((x\_n, y\_n)\), \((x\_1, y\_1)\)]\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  "Utiliza el teorema de Green para calcular las siguientes integrales de l\
\[IAcute]nea.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["\[Gamma]",
                FontWeight->"Bold"]], " ", 
            \(\(\[ExponentialE]\^\(\ y\)\) \[DifferentialD]x\)}], "+", 
          \(2  x\ \(\[ExponentialE]\^\(\ y\)\) \[DifferentialD]y\)}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] = 
        \([\((0, 0)\), \((1, 0)\), \((1, 1)\), \((0, 1)\), \((0, 0)\)]\)\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["\[Gamma]",
                FontWeight->"Bold"]], " ", 
            \(\(x\^2\) \(y\^2\) \[DifferentialD]x\)}], "+", 
          \(4  x\ \(y\^3\) \[DifferentialD]y\)}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] = \([\((0, 0)\), \((1, 3)\), \((0, 3)\), \((0, 0)\)]\)\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["\[Gamma]",
                FontWeight->"Bold"]], " ", 
            \(\((y + \[ExponentialE]\^\(\ x\^3\))\) \[DifferentialD]x\)}], 
          "+", \(\((2  x + cos\ y\^2)\) \[DifferentialD]y\)}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Gamma]", 
          StyleBox[" ",
            FontWeight->"Bold"]}], TraditionalForm]]],
  "es la curva frontera de la regi\[OAcute]n limitada por las \
par\[AAcute]bolas ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x = y\^2\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["\[Gamma]",
                FontWeight->"Bold"]], " ", 
            \(\((x\^3 - \(\(y\^3\)\^\ \))\) \[DifferentialD]x\)}], "+", 
          \(\((x\^3 + \ y\^3)\) \[DifferentialD]y\)}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Gamma]", 
          StyleBox[" ",
            FontWeight->"Bold"]}], TraditionalForm]]],
  "es la curva frontera de la regi\[OAcute]n limitada por las circunferencias \
",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 1\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 9\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "a) El centroide de una regi\[OAcute]n plana ",
  Cell[BoxData[
      \(TraditionalForm\`D \[Subset] \[DoubleStruckCapitalR]\^2\)]],
  "se define como el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((c\_1, c\_2)\)\)]],
  " cuyas coordenadas vienen dadas por"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(c\_1\), "=", 
          RowBox[{\(1\/\(\[CapitalAAcute]rea \((D)\)\)\), 
            RowBox[{"\[Integral]", 
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["D",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], " ", 
                \(x\ \[DifferentialD]\((x, y)\)\)}]}]}]}], ",", "    ", 
        RowBox[{\(c\_2\), "=", 
          RowBox[{\(1\/\(\[CapitalAAcute]rea \((D)\)\)\), 
            RowBox[{"\[Integral]", 
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["D",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], " ", 
                \(y\ \[DifferentialD]\((x, y)\)\)}]}]}]}]}], TextForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " es la regi\[OAcute]n limitada por un camino cerrado simple, \[Gamma], \
justifica que"
}], "ExerciseText"],

Cell[BoxData[
    \(TextForm
    \`c\_1 = \(1\/\(2  \[CapitalAAcute]rea \((D)\)\)\) 
        \(\[Integral]\_\[Gamma]\ x\^2\ \[DifferentialD]y\), \ \ \ 
    c\_2 = \(-\(1\/\(2  \[CapitalAAcute]rea \((D)\)\)\)\) 
        \(\[Integral]\_\[Gamma]\ \(\(y\ \)\^2\) \[DifferentialD]x\)\)], "Text",\

  TextAlignment->Center],

Cell["\<\
b) Calcula el centroide del tri\[AAcute]ngulo de v\[EAcute]rtices (0,0), \
(1,0) y (0,1).
c) Calcula el centroide de un semic\[IAcute]rculo de radio R.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 10", "Exercise"],

Cell[TextData[{
  "Haz uso del teorema de Green para dominios con agujeros o bien del teorema \
5 para probar que la integral de l\[IAcute]nea del campo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", 
            \(\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)}], "\[Rule]", 
          "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
  " dado por"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x, y\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                StyleBox[\(-y\),
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox[\(x\^2\),
                    FontSlant->"Italic"], 
                  StyleBox["+",
                    FontSlant->"Plain"], 
                  StyleBox[\(y\^2\),
                    FontSlant->"Italic"]}]], ",", 
              FractionBox[
                StyleBox["x",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox[\(x\^2\),
                    FontSlant->"Italic"], 
                  StyleBox["+",
                    FontSlant->"Plain"], 
                  StyleBox[\(y\^2\),
                    FontSlant->"Italic"]}]]}], ")"}]}], "        "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[
"sobre cualquier curva cerrada simple que rodee el origen es igual a 2\[Pi].\n\
Prueba de la misma forma que la integral de l\[IAcute]nea del campo"], 
  "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x, y\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                RowBox[{"2", 
                  StyleBox["x",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["y",
                    FontSlant->"Italic"]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox[\(x\^2\),
                        FontSlant->"Italic"], 
                      StyleBox["+",
                        FontSlant->"Plain"], 
                      StyleBox[\(y\^2\),
                        FontSlant->"Italic"]}], 
                    StyleBox[")",
                      FontSlant->"Italic"]}], "2"]], ",", 
              FractionBox[
                RowBox[{
                  SuperscriptBox[
                    StyleBox["y",
                      FontSlant->"Italic"], "2"], "-", 
                  SuperscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], "2"]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox[\(x\^2\),
                        FontSlant->"Italic"], 
                      StyleBox["+",
                        FontSlant->"Plain"], 
                      StyleBox[\(y\^2\),
                        FontSlant->"Italic"]}], 
                    StyleBox[")",
                      FontSlant->"Italic"]}], "2"]]}], ")"}]}], "        "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
sobre cualquier curva cerrada simple que rodee el origen es igual a 0.\
\>", "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Campos conservativos. Teorema de Green"], "Header"]}, {
    Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Campos conservativos. Teorema de Green"], "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.32.1"->{
    Cell[2069, 65, 85, 2, 71, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"],
    Cell[2157, 69, 86, 2, 71, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.32.1", 124964, 3762}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 55, 0, 99, "Title"],
Cell[1812, 53, 188, 6, 102, "Author"],

Cell[CellGroupData[{
Cell[2025, 63, 41, 0, 93, "Section"],
Cell[2069, 65, 85, 2, 71, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2157, 69, 86, 2, 71, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2246, 73, 511, 10, 277, "Input",
  InitializationCell->True],
Cell[2760, 85, 1925, 34, 626, "Input",
  InitializationCell->True],
Cell[4688, 121, 2149, 36, 700, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[6874, 162, 39, 0, 61, "Section"],
Cell[6916, 164, 783, 20, 94, "Text"],
Cell[7702, 186, 930, 24, 64, "Text"],
Cell[8635, 212, 1231, 33, 125, "Text"],
Cell[9869, 247, 3740, 128, 284, "Text"],
Cell[13612, 377, 652, 16, 93, "Text"],
Cell[14267, 395, 310, 5, 35, "Text"],
Cell[14580, 402, 286, 9, 41, "Text"],
Cell[14869, 413, 2474, 63, 64, "Text"],
Cell[17346, 478, 1164, 38, 74, "Text"],
Cell[18513, 518, 79, 0, 41, "Text"],
Cell[18595, 520, 699, 20, 73, "Text"],
Cell[19297, 542, 135, 3, 41, "Text"],
Cell[19435, 547, 1150, 37, 121, "Text"],
Cell[20588, 586, 176, 6, 41, "Text"],
Cell[20767, 594, 2269, 73, 119, "Text"],
Cell[23039, 669, 6598, 163, 108, "Text"],
Cell[29640, 834, 1359, 43, 98, "Text"],
Cell[31002, 879, 1548, 49, 119, "Text"],
Cell[32553, 930, 2615, 73, 60, "Text"],
Cell[35171, 1005, 318, 7, 67, "Text"],
Cell[35492, 1014, 1368, 43, 93, "Text"],
Cell[36863, 1059, 5893, 156, 60, "Text"],
Cell[42759, 1217, 119, 3, 41, "Text"],
Cell[42881, 1222, 2743, 81, 60, "Text"],
Cell[45627, 1305, 516, 17, 67, "Text"],
Cell[46146, 1324, 1631, 52, 57, "Text"],
Cell[47780, 1378, 393, 10, 67, "Text"],
Cell[48176, 1390, 76, 1, 41, "Text"],
Cell[48255, 1393, 424, 12, 67, "Text"],
Cell[48682, 1407, 2182, 62, 63, "Text"],
Cell[50867, 1471, 335, 8, 41, "Text"],
Cell[51205, 1481, 579, 18, 64, "Text"],
Cell[51787, 1501, 480, 17, 42, "Text"],
Cell[52270, 1520, 333, 8, 67, "Text"],
Cell[52606, 1530, 145, 3, 41, "Text"],
Cell[52754, 1535, 2207, 74, 68, "Text"],
Cell[54964, 1611, 1054, 32, 66, "Text"],
Cell[56021, 1645, 722, 22, 41, "Text"],
Cell[56746, 1669, 843, 26, 61, "Text"],
Cell[57592, 1697, 744, 22, 67, "Text"],
Cell[58339, 1721, 2543, 75, 61, "Text"],
Cell[60885, 1798, 533, 13, 67, "Text"],
Cell[61421, 1813, 820, 25, 61, "Text"],
Cell[62244, 1840, 49, 0, 41, "Text"],
Cell[62296, 1842, 2459, 70, 67, "Text"],
Cell[64758, 1914, 95, 2, 41, "Text"],
Cell[64856, 1918, 601, 15, 63, "Text"],
Cell[65460, 1935, 62, 0, 41, "Text"],
Cell[65525, 1937, 700, 20, 67, "Text"],
Cell[66228, 1959, 2287, 59, 249, "Text"],
Cell[68518, 2020, 1775, 62, 68, "Text"],
Cell[70296, 2084, 169, 3, 41, "Text"],
Cell[70468, 2089, 2505, 87, 119, "Text"],
Cell[72976, 2178, 439, 13, 64, "Text"],
Cell[73418, 2193, 142, 3, 41, "Text"],
Cell[73563, 2198, 573, 10, 202, "Input"],
Cell[74139, 2210, 373, 8, 67, "Text"],

Cell[CellGroupData[{
Cell[74537, 2222, 31, 0, 68, "Exercise"],
Cell[74571, 2224, 2588, 75, 203, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77196, 2304, 31, 0, 68, "Exercise"],
Cell[77230, 2306, 4547, 139, 183, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[81814, 2450, 31, 0, 68, "Exercise"],
Cell[81848, 2452, 370, 11, 41, "ExerciseText"],
Cell[82221, 2465, 779, 24, 61, "Text"],
Cell[83003, 2491, 137, 3, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[83177, 2499, 31, 0, 68, "Exercise"],
Cell[83211, 2501, 346, 11, 41, "ExerciseText"],
Cell[83560, 2514, 1479, 42, 67, "Text"],
Cell[85042, 2558, 303, 8, 41, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[85394, 2572, 35, 0, 93, "Section"],
Cell[85432, 2574, 3563, 85, 455, "Text"],
Cell[88998, 2661, 282, 5, 67, "Text"],
Cell[89283, 2668, 56, 1, 72, "Input"],
Cell[89342, 2671, 113, 5, 41, "Text"],
Cell[89458, 2678, 1915, 59, 127, "Text"],
Cell[91376, 2739, 1901, 48, 73, "Text"],
Cell[93280, 2789, 235, 8, 41, "Text"],
Cell[93518, 2799, 231, 4, 67, "Text"],
Cell[93752, 2805, 1866, 56, 128, "Text"],
Cell[95621, 2863, 1385, 36, 61, "Text"],
Cell[97009, 2901, 151, 3, 41, "Text"],
Cell[97163, 2906, 1197, 17, 223, "Text"],
Cell[98363, 2925, 6709, 222, 245, "Text"],
Cell[105075, 3149, 2351, 63, 80, "Text"],
Cell[107429, 3214, 252, 4, 67, "Text"],
Cell[107684, 3220, 1341, 44, 41, "Text"],
Cell[109028, 3266, 1306, 38, 80, "Text"],
Cell[110337, 3306, 289, 5, 67, "Text"],
Cell[110629, 3313, 141, 3, 41, "Text"],
Cell[110773, 3318, 56, 1, 94, "Input"],
Cell[110832, 3321, 287, 5, 67, "Text"],

Cell[CellGroupData[{
Cell[111144, 3330, 31, 0, 68, "Exercise"],
Cell[111178, 3332, 2332, 70, 169, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[113547, 3407, 31, 0, 68, "Exercise"],
Cell[113581, 3409, 1643, 50, 177, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[115261, 3464, 31, 0, 68, "Exercise"],
Cell[115295, 3466, 2545, 80, 245, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[117877, 3551, 31, 0, 68, "Exercise"],
Cell[117911, 3553, 303, 8, 41, "ExerciseText"],
Cell[118217, 3563, 855, 22, 62, "Text"],
Cell[119075, 3587, 193, 6, 41, "ExerciseText"],
Cell[119271, 3595, 317, 7, 63, "Text"],
Cell[119591, 3604, 183, 4, 75, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[119811, 3613, 32, 0, 68, "Exercise"],
Cell[119846, 3615, 454, 12, 67, "ExerciseText"],
Cell[120303, 3629, 1135, 34, 61, "Text"],
Cell[121441, 3665, 184, 3, 75, "ExerciseText"],
Cell[121628, 3670, 1875, 52, 67, "Text"],
Cell[123506, 3724, 102, 2, 41, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

